
--Rain parameters
kPPS = 20;               -- Number of particles generated per second
kGravity =100;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("bubble");
  SetBlendMode(kBlendNormal);
  SetNumParticles(200);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(5500);
TestDone = NewTimeout(10000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-380, 300, 0), Vec3(380,300,0) );
   InitVelocity( "vRange", Vec3(-10, -240, 10), Vec3(10,-150, 100) );
   InitScale( "fRange", .08, .6 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
 DoColor("cFade",
      Color(1, 1,1, 1), 2500,
      Color(1, 1, 1, 0), 1500,
      Color(1, 1, 1, 0));
  --DoScale("fScale",
-- .05, 100,
 --  .3, 1500);
   Do("expire", 10000)

DoUp( "vRotate", -.0, .0 );


end

